<?php

declare(strict_types=1);

namespace Drupal\pinto;

use Pinto\PintoMapping;

/**
 * Pinto Mapping Factory.
 *
 * Internal factory for creating mapping objects. This is used since Drupal's
 * container (\Drupal\Component\DependencyInjection\Dumper\OptimizedPhpArrayDumper::dumpValue)
 * is incapable of having PHP objects as parameters.
 * Throws "Unable to dump a service container if a parameter is an object
 * without _serviceId.".
 *
 * @internal
 */
final class PintoMappingFactory {

  private array $definitions;

  /**
   * @var array<class-string, \Pinto\Resource\ResourceInterface>
   */
  private array $resources;

  public function __construct(
    string $resources,
    string $definitions,
    private array $buildInvokers,
    private array $types,
    private array $lsbFactoryCanonicalObjectClasses,
  ) {
    // From \Drupal\pinto\PintoCompilerPass.
    // @phpstan-ignore-next-line
    $this->definitions = \unserialize($definitions);
    // @phpstan-ignore-next-line
    $this->resources = \unserialize($resources);
  }

  public function create(): PintoMapping {
    return new PintoMapping(
      $this->resources,
      $this->definitions,
      $this->buildInvokers,
      $this->types,
      $this->lsbFactoryCanonicalObjectClasses,
    );
  }

}
