<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\StreamWrapper;

use Drupal\pinto\Object\DrupalObjectTrait;
use Pinto\Attribute\Asset\Css;
use Pinto\Attribute\ObjectType\Slots;
use Pinto\Slots\Build;

#[Slots(slots: ['text'])]
#[Css('styles.css')]
final class AssetStreamWrapper {

  use DrupalObjectTrait;

  public function __invoke(): mixed {
    return $this->pintoBuild(static fn (Build $build): Build => $build);
  }

}
