<?php

declare(strict_types=1);

namespace Drupal\Tests\pinto\Kernel;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\KernelTests\KernelTestBase;
use Drupal\pinto_test\NonDiscovery\NonDiscovery;
use Drupal\pinto_test\Pinto\Generic\Objects;
use Pinto\List\Resource\ObjectListEnumResource;
use Pinto\PintoMapping;

/**
 * Tests namespace parameter.
 *
 * @group pinto
 * @covers \Drupal\pinto\PintoCompilerPass
 */
final class PintoNamespaceDiscoveryTest extends KernelTestBase {

  protected static $modules = [
    'pinto_test',
    'pinto',
  ];

  public function testNamespaceDiscovery(): void {
    // We want loose comparison.
    // @phpstan-ignore-next-line
    static::assertTrue(\in_array(
      ObjectListEnumResource::createFromEnum(NonDiscovery::NonDiscoveryObject),
      \iterator_to_array(static::pintoMapping()->getResources()),
      strict: FALSE,
    ));
    // @phpstan-ignore-next-line
    static::assertTrue(\in_array(
      ObjectListEnumResource::createFromEnum(Objects::ObjectTest),
      \iterator_to_array(static::pintoMapping()->getResources()),
      strict: FALSE,
    ));
  }

  public function register(ContainerBuilder $container): void {
    parent::register($container);

    $container->setParameter('pinto.namespaces', [
      'Pinto',
      'NonDiscovery',
    ]);
  }

  private static function pintoMapping(): PintoMapping {
    /** @var \Pinto\PintoMapping */
    return \Drupal::service(PintoMapping::class);
  }

}
