<?php

declare(strict_types=1);

namespace Drupal\pinto\Build;

use Pinto\Resource\ResourceInterface;
use Pinto\Slots\Build;

/**
 * Not for extension.
 *
 * @final
 */
interface BuildRegistryInterface {

  public function createToken(
    ResourceInterface $resource,
    Build $built,
  ): BuildToken;

  /**
   * @template E of array<mixed>
   * @phpstan-param E $element
   * @phpstan-return array{'#markup': string|\Stringable}&E
   */
  public function render(BuildToken $buildToken, array $element): array;

}
