<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\CanonicalProduct;

use Drupal\pinto\Object\DrupalObjectTrait;
use Pinto\Attribute\ObjectType\Slots;
use Pinto\CanonicalProduct\CanonicalFactoryTrait;
use Pinto\Slots\Build;

/**
 * Tests canonical product.
 */
#[Slots(slots: ['canonical_product_slot'])]
class CanonicalProductRoot {

  use CanonicalFactoryTrait;
  use DrupalObjectTrait;

  /**
   * Constructor.
   */
  public function __construct(
    protected readonly string $text,
  ) {
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(static function (Build $build): Build {
      return $build
        ->set('canonical_product_slot', 'Value from Root!');
    });
  }

}
