<?php

declare(strict_types=1);

namespace Drupal\pinto_test\Pinto\Standalone\StandaloneObjectTypeMethod;

use Drupal\pinto\Attribute\ObjectType\ThemeDefinition;
use Drupal\pinto\Object\DrupalObjectTrait;
use Drupal\pinto_test\Pinto\DependencyOn\PintoListDependencies;
use Pinto\Attribute\DependencyOn;

#[DependencyOn(PintoListDependencies::Charlie)]
final class StandaloneObjectTypeMethod {

  use DrupalObjectTrait;

  #[ThemeDefinition]
  public static function theme(): array {
    return [
      'variables' => [
        'test_text' => NULL,
      ],
    ];
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(static function (array $build): mixed {
      return $build + [
        '#test_text' => [
          '#markup' => 'Content for StandaloneObjectTypeMethod!',
        ],
      ];
    });
  }

}
