<?php

declare(strict_types=1);

namespace Drupal\pinto_block;

use Drupal\block_content\BlockContentInterface;

interface BlockBundleInterface {

  /**
   * Creates an object for a block content.
   *
   * @param \Drupal\block_content\BlockContentInterface $blockContent
   *   The object class may not be the same as the configured bundle class if it
   *   was created and serialized before the bundle class was created and
   *   configured.
   * @param \Drupal\pinto_block\ObjectContextInterface $objectContext
   *   The context, including the object embedded onto, and the view mode.
   */
  public static function createForLayoutBuilderBlockContent(
    BlockContentInterface $blockContent,
    ObjectContextInterface $objectContext,
  ): static;

}
