<?php

declare(strict_types=1);

namespace Drupal\pinto_block;

use Drupal\Core\Entity\ContentEntityInterface;

final class ObjectContext implements ObjectContextInterface {

  private function __construct(
    public ContentEntityInterface $entity,
    public string $viewMode,
  ) {
  }

  public static function create(
    ContentEntityInterface $entity,
    string $viewMode,
  ): static {
    return new static(
      $entity,
      $viewMode,
    );
  }

}
