Pinto Entity

# License

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
Street, Fifth Floor, Boston, MA 02110-1301 USA.

# Usage

The project currently supports two modes:

- Entry point via known Pinto Component.
- Entry point via known Bundle classes.

## Modes

### Pinto Component

Add mapping on a Pinto Component.

On any known Pinto component, add a new entry point method:

```php
  #[EntityView(entityType: 'node', bundles: 'page', viewModes: 'full')]
  public static function viewEntity(\Drupal\node\NodeInterface $entity): static {
    // @todo Create an instance of this object...
  }
```

The method must return an instance of the component it is attached to.

See details below for how the method should be set up, including its parameters.

### Bundle class

Add mapping on a bundle class.

On any known bundle component, add a new entry point method:

For this example, BCA and its `#[Bundle]` attribute is used for discovery.

```php
use \Drupal\bca\Attribute\Bundle;

#[Bundle(entityType: 'node', bundle: self::BUNDLE)]
final class Article extends Node {

  public const BUNDLE = 'page';

  #[EntityView]
  public static function renderAsFull(
    self $entity,
  ): \Namespace\To\The\Component {
    // @todo Create an instance of this object...
  }
```

The method must have a return type of a known Pinto component.

See details below for how the method should be set up, including its parameters.

The `$entityType`, `$bundles`, and `$viewModes`, parameters of `#[EntityView]` become optional when used with a bundle class.

## `#[EntityView]` method entry point

The `#[EntityView]` may be attached to any `public` `static` method.

The name of the method is not important, nor are the names of the parameters.

Multiple `#[EntityView]` entry point methods may be included within the same class.

The parameters of the method may include any type that extends
`EntityInterface`, i.e, `EntityInterface`, `Node`, `NodeInterface` or even
specific bundle classes. When the method is located on a bundle class, the type may be `self`.
This parameter is given the instance of the entity being loaded.

A parameter typed with `\Drupal\pinto_entity\EntityView\EntityViewContext` may
be defined. An instance of `EntityViewContext` will be provided, which
includes the view mode and other context.
