<?php

declare(strict_types=1);

namespace Drupal\pinto_entity\EntityView;

use Drupal\Core\Entity\EntityInterface;

final class Bundle {

  public function __construct(
    public string $entityType,
    public string $bundle,
  ) {}

  public function equals(Bundle $other): bool {
    return $other->entityType === $this->entityType && $other->bundle === $this->bundle;
  }

  public static function fromEntity(EntityInterface $entity): Bundle {
    return new static($entity->getEntityTypeId(), $entity->bundle());
  }

}
