<?php

declare(strict_types=1);

namespace Drupal\pinto_entity_test\Entity;

use Drupal\bca\Attribute\Bundle;
use Drupal\entity_test\Entity\EntityTest;
use Drupal\pinto_entity\EntityView\Attribute\EntityView;
use Drupal\pinto_entity_test\Pinto\Component1\PintoEntityTestComponent;

#[Bundle(
  entityType: 'entity_test',
  bundle: 'entity_test',
)]
final class PintoEntityTestEntity extends EntityTest {

  #[EntityView]
  public static function view(self $entity): PintoEntityTestComponent {
    return new PintoEntityTestComponent(foo: (string) $entity->label());
  }

}
