<?php

declare(strict_types=1);

namespace Drupal\Tests\pinto_entity\Functional;

use Drupal\pinto_entity_test\Entity\PintoEntityTestEntity;
use Drupal\Tests\BrowserTestBase;
use Drupal\user\Entity\Role;
use Drupal\user\RoleInterface;

/**
 * @group pinto_entity
 */
final class PintoEntityTest extends BrowserTestBase {

  protected $defaultTheme = 'stark';

  protected static $modules = [
    'pinto',
    'pinto_entity',
    'pinto_entity_test',
    'entity_test',
    'user',
    'bca',
  ];

  public function testByBundle(): void {
    (Role::load(RoleInterface::ANONYMOUS_ID) ?? throw new \LogicException())
      ->grantPermission('view test entity')
      ->save();

    $label = $this->randomMachineName();
    $e = PintoEntityTestEntity::create(['name' => $label]);
    $e->save();
    $this->drupalGet($e->toUrl());
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->responseContains('PintoEntityTestComponent: ' . $label);
  }

}
