<?php

declare(strict_types=1);

namespace Drupal\pinto_entity\DependencyInjection;

use Drupal\pinto\PintoMappingFactory;
use Drupal\pinto_entity\EntityView\Attribute\EntityView;
use Pinto\Attribute\Definition;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * @phpstan-type PintoEntityMapping array<array{
 *   \Drupal\pinto_entity\EntityView\Bundle,
 *   \Drupal\pinto_entity\EntityView\ViewMode,
 *   string,
 *   string[],
 *   string[],
 * }>
 */
final class PintoEntityCompilerPass implements CompilerPassInterface {

  public function process(ContainerBuilder $container): void {
    /** @var array<class-string<\Pinto\List\ObjectListInterface>> $enumClasses */
    $enumClasses = $container->getDefinition(PintoMappingFactory::class)->getArgument('$enumClasses');

    /** @var PintoEntityMapping $mapping */
    $mapping = [];
    foreach ($enumClasses as $enumClass) {
      foreach ($enumClass::cases() as $case) {
        $rCase = new \ReflectionEnumUnitCase($case::class, $case->name);
        $definitionAttr = ($rCase->getAttributes(Definition::class)[0] ?? NULL)?->newInstance();
        if (NULL !== $definitionAttr) {
          $componentClass = $definitionAttr->className;

          $rClass = new \ReflectionClass($componentClass);

          \array_push($mapping, ...\iterator_to_array(EntityView::findOnClass($rClass, [$componentClass])));
        }

      }
    }

    // Serialize until https://www.drupal.org/project/drupal/issues/3522410 is resolved.
    $container->setParameter('pinto_entity.mapping', \serialize($mapping));
  }

}
