<?php

declare(strict_types=1);

namespace Drupal\pinto_entity;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityViewBuilderInterface;
use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\Field\FieldItemListInterface;

/**
 * The aim with this is to inject our code as early as possible so Drupal
 * doesn't bother building field displays, etc, as a form of optimization.
 */
final class PintoEntityEntityViewBuilder implements EntityViewBuilderInterface {

  public function __construct(
    private readonly PintoEntity $pintoEntity,
    private readonly EntityViewBuilderInterface $original,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  public function view(EntityInterface $entity, $view_mode = 'full', $langcode = NULL) {
    $built = $this->pintoEntity->view($entity, $view_mode, $langcode);

    if (NULL === $built) {
      return $this->original->view($entity, $view_mode, $langcode);
    }

    return [
      // Put it in a sub key so the PintoComponentElement #pre_render doesn't get
      // clobbered by the #pre_render in EntityViewController.
      '___pinto_entity' => $built,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildComponents(array &$build, array $entities, array $displays, $view_mode): void {
    $this->original->buildComponents($build, $entities, $displays, $view_mode);
  }

  /**
   * {@inheritdoc}
   */
  public function viewMultiple(array $entities = [], $view_mode = 'full', $langcode = NULL) {
    return $this->original->viewMultiple($entities, $view_mode, $langcode);
  }

  public function resetCache(?array $entities = NULL): void {
    $this->original->resetCache($entities);
  }

  /**
   * {@inheritdoc}
   *
   * @phpstan-ignore-next-line
   */
  public function viewField(FieldItemListInterface $items, $display_options = []) {
    return $this->original->viewField($items, $display_options);
  }

  /**
   * {@inheritdoc}
   */
  public function viewFieldItem(FieldItemInterface $item, $display_options = []) {
    return $this->original->viewFieldItem($item, $display_options);
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheTags() {
    return $this->original->getCacheTags();
  }

}
