<?php

declare(strict_types=1);

namespace Drupal\pinto_layout\Discovery;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\pinto_layout\Attribute\Regions;
use Pinto\List\ObjectListInterface;

/**
 * @internal
 */
final class FrozenLayoutDefinition {

  public readonly string $factoryMethod;

  /**
   * Constructs a frozen definition.
   *
   * $regionAttributesAsParameter is a array of parameter names (usually zero or one).
   * Only used when $regionDataMode = RegionDataMode::AsParameterNamesFromRegionNames.
   *
   * @phpstan-param string[] $regionAttributesAsParameter
   * @internal
   */
  public function __construct(
    public string $id,
    public TranslatableMarkup|string $label,
    public readonly ObjectListInterface $pintoEnum,
    public readonly Regions $regions,
    \ReflectionFunctionAbstract $factoryMethod,
    public readonly RegionDataMode $regionDataMode,
    public readonly array $regionAttributesAsParameter,
  ) {
    $this->factoryMethod = $factoryMethod instanceof \ReflectionMethod ? \sprintf('%s::%s', $factoryMethod->getDeclaringClass()->getName(), $factoryMethod->getName()) : throw new \LogicException('Unhandled factory method type');
  }

  public function layoutId(): string {
    return $this->id;
  }

  public function layoutLabel(): TranslatableMarkup|string {
    return $this->label;
  }

}
