<?php

declare(strict_types=1);

namespace Drupal\pinto_layout\Discovery;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\pinto_layout\Attribute\Region;

/**
 * @internal
 */
final class FrozenRegion {

  private function __construct(
    public string $name,
    public TranslatableMarkup|string $label,
  ) {
  }

  public static function create(Region $region): static {
    $regionName = $region->name ?? throw new \Exception('Region name must be set at this point.');
    return new static(
      name: $regionName,
      label: $region->label ?? $regionName,
    );
  }

}
