<?php

declare(strict_types=1);

namespace Drupal\pinto_layout\PintoLayout\Data;

/**
 * A data transfer object for passing region data and Layout Builder attributes (when available).
 */
final class LayoutData {

  private function __construct(
    public readonly RegionData $regionsData,
    public readonly RegionAttributes $regionAttributes,
  ) {
  }

  /**
   * @internal
   */
  public static function fromRegionData(
    RegionData $regionData,
    RegionAttributes $regionAttributes,
  ): static {
    return new static($regionData, $regionAttributes);
  }

}
