<?php

declare(strict_types=1);

namespace Drupal\pinto_layout\PintoLayout\Data;

/**
 * A data transfer object for passing region data.
 */
final class RegionData {

  /**
   * @phpstan-param array<string, array<mixed>> $regionsData
   */
  private function __construct(
    public array $regionsData,
  ) {
  }

  /**
   * Create from data passed to LayoutInterface::build(regions).
   *
   * @param array<string, array<mixed>> $regionsData
   *   Region data as passed to \Drupal\Core\Layout\LayoutInterface::build(regions).
   *
   * @internal
   */
  public static function fromData($regionsData): static {
    return new static(
      regionsData: $regionsData,
    );
  }

  /**
   * @internal
   */
  public function add(string $regionName, string $childKey, mixed $build): void {
    $this->regionsData[$regionName][$childKey] = $build;
  }

  /**
   * @throws \InvalidArgumentException
   */
  public function getRegion(string $regionName): mixed {
    return $this->regionsData[$regionName] ?? throw new \InvalidArgumentException($regionName . ' region does not exist.');
  }

}
