<?php

declare(strict_types=1);

namespace Drupal\pinto_layout_test\Pinto;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\pinto\Object\DrupalObjectTrait;
use Drupal\pinto_layout\Attribute\LayoutDefinition;
use Drupal\pinto_layout\Attribute\Region;
use Pinto\Slots\Build;

#[LayoutDefinition(
  label: new TranslatableMarkup('A custom label'),
)]
final class LayoutLabel {

  use DrupalObjectTrait;

  public function __construct(
    #[Region]
    public readonly mixed $slot1,
  ) {
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(static function (Build $build): Build {
      return $build;
    });
  }

}
