<?php

declare(strict_types=1);

namespace Drupal\pinto_layout_test;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\pinto_layout\PintoLayout\Data\LayoutData;
use Drupal\pinto_layout\PintoLayout\External\ExternallyDefined;
use Drupal\pinto_layout\PintoLayout\External\ExternallyDefinedInterface;
use Drupal\pinto_layout_test\Pinto\External1;
use Drupal\pinto_layout_test\Pinto\PintoLayoutTestList;

final class PintoLayoutDefinitions implements ExternallyDefinedInterface {

  public function getDefinitions(): iterable {
    yield ExternallyDefined::create(
      id: 'external-1',
      label: new TranslatableMarkup('External #1'),
      pintoEnum: PintoLayoutTestList::External1,
      regions: [
        'external_region_1',
        'external_region_2',
      ],
      factoryMethod: [static::class, 'createExternal1'],
    );

    yield ExternallyDefined::create(
      id: 'external-1-b',
      label: new TranslatableMarkup('External #1b'),
      pintoEnum: PintoLayoutTestList::External1,
      regions: [
        'external_region_1',
        'external_region_2',
      ],
      factoryMethod: \sprintf('%s::createExternal1', static::class),
    );
  }

  /**
   * Manual wiring for External1.
   */
  public static function createExternal1(LayoutData $layoutData): External1 {
    return new External1(
      ext1: $layoutData->regionsData->getRegion('external_region_1'),
      ext2: $layoutData->regionsData->getRegion('external_region_2'),
      regionAttributes: $layoutData->regionAttributes,
    );
  }

}
