<?php

declare(strict_types=1);

namespace Drupal\pinto_layout_test\Pinto;

use Drupal\pinto\Object\DrupalObjectTrait;
use Drupal\pinto_layout\Discovery\FrozenLayoutDefinition;
use Drupal\pinto_layout\PintoLayout\Data\LayoutData;
use Drupal\pinto_layout\PintoLayout\Data\RegionAttributes;
use Pinto\Slots\Build;

final class ExternalConstructor {

  use DrupalObjectTrait;

  public function __construct(
    public readonly mixed $externalConstructorParam1,
    public readonly mixed $externalConstructorParam2,
    public RegionAttributes $regionAttributes,
    public FrozenLayoutDefinition $frozenLayoutDefinition,
    public LayoutData $layoutData,
    public array $attributes = [],
  ) {
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(function (Build $build): Build {
      return $build
        ->set('attributes', $this->regionAttributes->containerAttributes())
        ->set('regionAttributes', $this->regionAttributes->regionsAsArray());
    });
  }

}
