<?php

declare(strict_types=1);

namespace Drupal\pinto_layout_test\Pinto;

use Pinto\Attribute\Asset\Css;
use Pinto\Attribute\Definition;
use Pinto\Attribute\ObjectType\Slots;
use Pinto\List\ObjectListInterface;
use Pinto\List\ObjectListTrait;
use function Safe\realpath;

#[Slots(bindPromotedProperties: TRUE)]
#[Css('styles.css')]
enum PintoLayoutTestList implements ObjectListInterface {

  use ObjectListTrait;

  #[Definition(Simple::class)]
  case Simple;

  #[Definition(SimpleNoAttributes::class)]
  case SimpleNoAttributes;

  #[Definition(SlotsInClassLayoutDefinition::class)]
  case SlotsInClassLayoutDefinition;

  #[Definition(LayoutId::class)]
  case LayoutId;

  #[Definition(LayoutLabel::class)]
  case LayoutLabel;

  #[Definition(SimpleFactoryViaInterface::class)]
  case SimpleFactoryViaInterface;

  #[Definition(ClassRegions::class)]
  case ClassRegions;

  #[Definition(SimpleFactoryViaClassLayoutDefinitionLayoutData::class)]
  case SimpleFactoryViaClassLayoutDefinitionLayoutData;

  #[Definition(SimpleFactoryViaClassLayoutDefinitionParameters::class)]
  case SimpleFactoryViaClassLayoutDefinitionParameters;

  #[Definition(SimpleFactoryViaClassLayoutDefinitionParametersWithRegionAttributes::class)]
  case SimpleFactoryViaClassLayoutDefinitionParametersWithRegionAttributes;

  #[Definition(External1::class)]
  case External1;

  #[Definition(ExternalConstructor::class)]
  case ExternalConstructor;

  public function templateDirectory(): string {
    return '@pinto_layout_test/templates/';
  }

  public function templateName(): string {
    return $this->name();
  }

  public function cssDirectory(): string {
    return realpath(__DIR__ . '/../../css');
  }

  public function jsDirectory(): string {
    throw new \LogicException('Not tested.');
  }

}
