<?php

declare(strict_types=1);

namespace Drupal\Tests\pinto_layout\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\pinto_layout\Hook\PintoLayoutHooks;
use Drupal\Tests\pinto_layout\PintoLayoutFixtures;

/**
 * @group pinto_layout
 */
final class PintoLayoutTest extends KernelTestBase {

  protected static $modules = [
    'pinto_layout_support',
    'pinto_layout_test',
    'layout_discovery',
    'layout_builder',
    'pinto_layout',
    'pinto',
  ];

  public function testDefinitions(): void {
    /** @var \Drupal\pinto_layout\Hook\PintoLayoutHooks $pintoLayoutHooks */
    $pintoLayoutHooks = \Drupal::service(PintoLayoutHooks::class);

    /** @var \Drupal\Core\Layout\LayoutDefinition[] $definitions */
    $definitions = [];
    $pintoLayoutHooks->layoutAlter($definitions);
    static::assertEqualsCanonicalizing([
      'a_layout',
      'external-1',
      'external-1-b',
      'external-constructor',
      'pinto_layout__classregions',
      'pinto_layout__layoutlabel',
      'pinto_layout__simple',
      'pinto_layout__simplefactoryviaclasslayoutdefinitionlayoutdata',
      'pinto_layout__simplefactoryviaclasslayoutdefinitionparameters',
      'pinto_layout__simplefactoryviaclasslayoutdefinitionparameterswithregionattributes',
      'pinto_layout__simplefactoryviainterface',
      'pinto_layout__slotsinclasslayoutdefinition',
    ], \array_keys($definitions));

    static::assertEquals([
      'slot1' =>
        [
          'label' => 'slot1',
        ],
      'slot2' =>
        [
          'label' => 'slot2',
        ],
      'slot3' =>
        [
          'label' => 'Slot 3 label',
        ],
    ], $definitions['pinto_layout__simple']->getRegions());
    static::assertEquals(
      [
        'sicldSlot1' =>
          [
            'label' => 'sicldSlot1',
          ],
        'sicldSlot2' =>
          [
            'label' => 'sicldSlot2',
          ],
      ], $definitions['pinto_layout__slotsinclasslayoutdefinition']->getRegions());
    static::assertEquals(
      [
        'slot1' =>
          [
            'label' => 'slot1',
          ],
      ], $definitions['a_layout']->getRegions());
    static::assertEquals(
      [
        'slot1' =>
          [
            'label' => 'slot1',
          ],
      ], $definitions['pinto_layout__layoutlabel']->getRegions());
    static::assertEquals(
      [
        'slot1' =>
          [
            'label' => 'slot1',
          ],
      ], $definitions['pinto_layout__simplefactoryviainterface']->getRegions());
    static::assertEquals(
      [
        'slot1' =>
          [
            'label' => 'slot1',
          ],
      ], $definitions['pinto_layout__classregions']->getRegions());
    static::assertEquals(
      [
        'slot1' =>
          [
            'label' => 'slot1',
          ],
      ], $definitions['pinto_layout__simplefactoryviaclasslayoutdefinitionlayoutdata']->getRegions());
    static::assertEquals(
      [
        'slot1' =>
          [
            'label' => 'slot1',
          ],
        'slot2' =>
          [
            'label' => 'slot2',
          ],
      ], $definitions['pinto_layout__simplefactoryviaclasslayoutdefinitionparameters']->getRegions());
    static::assertEquals(
      [
        'slot1' =>
          [
            'label' => 'slot1',
          ],
        'slot2' =>
          [
            'label' => 'slot2',
          ],
      ], $definitions['pinto_layout__simplefactoryviaclasslayoutdefinitionparameterswithregionattributes']->getRegions());
    static::assertEquals(
      [
        'external_region_1' =>
          [
            'label' => 'external_region_1',
          ],
        'external_region_2' =>
          [
            'label' => 'external_region_2',
          ],
      ], $definitions['external-1']->getRegions());
    static::assertEquals([
      'external_region_1' =>
        [
          'label' => 'external_region_1',
        ],
      'external_region_2' =>
        [
          'label' => 'external_region_2',
        ],
    ], $definitions['external-1-b']->getRegions());
    static::assertEquals([
      'externalConstructorParam1' =>
        [
          'label' => 'externalConstructorParam1',
        ],
      'externalConstructorParam2' =>
        [
          'label' => 'externalConstructorParam2',
        ],
    ], $definitions['external-constructor']->getRegions());

    $actualLayouts = [];
    foreach ($definitions as $definition) {
      $actualLayouts[$definition->id()] = $definition->getRegionNames();
    }
    static::assertEquals(PintoLayoutFixtures::ExpectedLayouts, $actualLayouts);
  }

}
