<?php

declare(strict_types=1);

namespace Drupal\pinto_layout\DependencyInjection;

use Drupal\pinto_layout\DrupalLayoutDiscovery\DrupalLayoutDefinitionRepository;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\Compiler\ServiceLocatorTagPass;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

final class PintoLayoutCompilerPass implements CompilerPassInterface {

  public function process(ContainerBuilder $container): void {
    $refs = [];
    foreach ($container->findTaggedServiceIds('pinto_layout.externally_defined') as $id => $tags) {
      $refs[$id] = new Reference($id);
    }

    $container->getDefinition(DrupalLayoutDefinitionRepository::class)
      ->setArgument('$externallyDefinedLocator', ServiceLocatorTagPass::register($container, $refs));
  }

}
