<?php

declare(strict_types=1);

namespace Drupal\pinto_layout_test\Pinto;

use Drupal\pinto\Object\DrupalObjectTrait;
use Drupal\pinto_layout\Attribute\LayoutDefinition;
use Drupal\pinto_layout\Attribute\Region;
use Pinto\Slots\Build;

#[LayoutDefinition(
  id: 'a_layout',
)]
final class LayoutId {

  use DrupalObjectTrait;

  public function __construct(
    #[Region]
    public readonly mixed $slot1,
  ) {
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(static function (Build $build): Build {
      return $build;
    });
  }

}
