<?php

declare(strict_types=1);

namespace Drupal\pinto_layout_test\Pinto;

use Drupal\pinto\Object\DrupalObjectTrait;
use Drupal\pinto_layout\Attribute\LayoutDefinition;
use Drupal\pinto_layout\Attribute\Region;
use Pinto\Slots\Build;

#[LayoutDefinition(
  factoryMethod: 'customFactory',
)]
final class SimpleFactoryViaClassLayoutDefinitionParameters {

  use DrupalObjectTrait;

  public function __construct(
    #[Region]
    public readonly mixed $slot1,
    #[Region]
    public readonly mixed $slot2,
    public array $attributes = [],
  ) {
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(static function (Build $build): Build {
      return $build;
    });
  }

  public static function customFactory(
    mixed $slot1,
    mixed $slot2,
  ): static {
    return new static(
      slot1: $slot1,
      slot2: $slot2,
    );
  }

}
