<?php

declare(strict_types=1);

namespace Drupal\pinto_layout_test\Pinto;

use Drupal\pinto\Object\DrupalObjectTrait;
use Drupal\pinto_layout\Attribute\LayoutDefinition;
use Drupal\pinto_layout\Attribute\Region;
use Drupal\pinto_layout\PintoLayout\Data\RegionAttributes;
use Pinto\Slots\Build;

#[LayoutDefinition(
  factoryMethod: 'customFactory',
)]
final class SimpleFactoryViaClassLayoutDefinitionParametersWithRegionAttributes {

  use DrupalObjectTrait;

  public function __construct(
    #[Region]
    public readonly mixed $slot1,
    #[Region]
    public readonly mixed $slot2,
    public RegionAttributes $regionAttributesRandomName,
    public array $attributes = [],
  ) {
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(function (Build $build): Build {
      return $build
        ->set('attributes', $this->regionAttributesRandomName->containerAttributes())
        ->set('regionAttributesRandomName', $this->regionAttributesRandomName->regionsAsArray());
    });
  }

  public static function customFactory(
    mixed $slot1,
    RegionAttributes $ra,
    mixed $slot2,
  ): static {
    return new static(
      slot1: $slot1,
      slot2: $slot2,
      regionAttributesRandomName: $ra,
    );
  }

}
