<?php

declare(strict_types=1);

namespace Drupal\pinto_layout\Attribute;

use Drupal\Core\StringTranslation\TranslatableMarkup;

#[\Attribute(flags: \Attribute::TARGET_CLASS)]
class LayoutDefinition {

  /**
   * A name of a static public method can be provided to override automatic behavior.
   *
   * @phpstan-param non-empty-string|null $factoryMethod
   * @phpstan-param array<string, class-string<\Drupal\Core\Plugin\PluginFormInterface>> $forms
   */
  public function __construct(
    public ?string $id = NULL,
    public TranslatableMarkup|string|null $label = NULL,
    public ?Regions $regions = NULL,
    public ?string $factoryMethod = NULL,
    public array $forms = [],
  ) {
  }

}
