<?php

declare(strict_types=1);

namespace Drupal\pinto_layout\DrupalLayoutDiscovery;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginFormBase;

/**
 * This class is a form that does nothing.
 *
 * Sadly, because PintoLayout implements PluginWithFormsInterface, it must always produce a 'configure' form, despite
 * PluginWithFormsInterface::hasFormClass existing as a form a production, because Drupal will throw exceptions.
 *
 * Thusly we cannot have *some* layout definitions that use PintoLayout have a form, while others do not.
 *
 * See the exception thrown in \Drupal\Core\Plugin\PluginFormFactory::createInstance(), and the caller at
 * \Drupal\layout_builder\Form\ConfigureSectionForm::getPluginForm().
 *
 * @property \Drupal\pinto_layout\DrupalLayoutDiscovery\PintoLayout<Configuration> $plugin
 * @phpstan-type Configuration array{}
 *
 * @internal
 */
final class NullPluginForm extends PluginFormBase {

  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    return $this->plugin->buildConfigurationForm($form, $form_state);
  }

  public function validateConfigurationForm(array &$form, FormStateInterface $form_state): void {
    $this->plugin->validateConfigurationForm($form, $form_state);
  }

  public function submitConfigurationForm(array &$form, FormStateInterface $form_state): void {
    $this->plugin->submitConfigurationForm($form, $form_state);
  }

}
