<?php

declare(strict_types=1);

namespace Drupal\pinto_layout\PintoLayout\Data;

/**
 * A data transfer object for passing region data and Layout Builder attributes (when available).
 */
final class LayoutData {

  /**
   * @phpstan-param PluginConfiguration<array<mixed>> $pluginConfiguration
   */
  private function __construct(
    public readonly RegionData $regionsData,
    public readonly RegionAttributes $regionAttributes,
    public readonly PluginConfiguration $pluginConfiguration,
  ) {
  }

  /**
   * @phpstan-param PluginConfiguration<array<mixed>> $pluginConfiguration
   * @internal
   */
  public static function fromRegionData(
    RegionData $regionData,
    RegionAttributes $regionAttributes,
    PluginConfiguration $pluginConfiguration,
  ): static {
    return new static($regionData, $regionAttributes, $pluginConfiguration);
  }

}
