<?php

declare(strict_types=1);

namespace Drupal\pinto_layout\PintoLayout\External;

/**
 * Add to a service to supply externally defined layouts.
 *
 * This is useful especially if:
 *   - The Pinto objects are not owned by you.
 *   - The objects are not specifically related to Drupal.
 *   - Cleanly define Pinto objects, without adding Drupal Layout metadata inline with an object.
 *
 * Implement this interface on a registered service, and ensure `autoconfigure` is enabled on the service.
 */
interface ExternallyDefinedInterface {

  /**
   * @phpstan-return iterable<ExternallyDefined>
   */
  public function getDefinitions(): iterable;

}
