<?php

declare(strict_types=1);

namespace Drupal\pinto_layout;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderInterface;
use Drupal\pinto_layout\DependencyInjection\PintoLayoutCompilerPass;
use Drupal\pinto_layout\PintoLayout\External\ExternallyDefinedInterface;

/**
 * @internal
 */
final class PintoLayoutServiceProvider implements ServiceProviderInterface {

  public function register(ContainerBuilder $container): void {
    $container->addCompilerPass(new PintoLayoutCompilerPass(), priority: -200);
    $container->registerForAutoconfiguration(ExternallyDefinedInterface::class)
      ->addTag('pinto_layout.externally_defined');
  }

}
