<?php

declare(strict_types=1);

namespace Drupal\pinto_layout_test\Forms;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginFormInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

final class SubformForm implements PluginFormInterface {

  use StringTranslationTrait;

  public function __construct(
    public ?string $size = NULL,
  ) {}

  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    $options = [1, 2, 4, 8, 16, 32, 64, 128];

    $form['size'] = [
      '#title' => $this->t('Border size'),
      '#type' => 'select',
      '#options' => \array_combine($options, $options),
      '#default_value' => $this->size,
    ];

    return $form;
  }

  public function validateConfigurationForm(array &$form, FormStateInterface $form_state): void {
  }

  public function submitConfigurationForm(array &$form, FormStateInterface $form_state): void {
    /** @var string|null $size */
    $size = $form_state->getValue('size');
    $this->size = $size;
  }

}
