<?php

declare(strict_types=1);

namespace Drupal\pinto_layout_test\Pinto;

use Drupal\pinto\Object\DrupalObjectTrait;
use Drupal\pinto_layout\PintoLayout\Data\RegionAttributes;
use Pinto\Slots\Build;

final class External1 {

  use DrupalObjectTrait;

  public function __construct(
    public readonly mixed $ext1,
    public readonly mixed $ext2,
    public RegionAttributes $regionAttributes,
    public array $attributes = [],
  ) {
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(function (Build $build): Build {
      return $build
        ->set('attributes', $this->regionAttributes->containerAttributes())
        ->set('regionAttributes', $this->regionAttributes->regionsAsArray());
    });
  }

}
