<?php

declare(strict_types=1);

namespace Drupal\pinto_layout_test\Pinto;

use Drupal\pinto\Object\DrupalObjectTrait;
use Drupal\pinto_layout\Attribute\LayoutDefinition;
use Drupal\pinto_layout\Attribute\Region;
use Drupal\pinto_layout\PintoLayout\Data\PluginConfiguration;
use Drupal\pinto_layout\PintoLayout\Data\RegionAttributes;
use Drupal\pinto_layout_test\Forms\LayoutFormsForm;
use Pinto\Slots\Build;

/**
 * @phpstan-import-type Configuration from LayoutFormsForm
 */
#[LayoutDefinition(
  forms: [
    'configure' => LayoutFormsForm::class,
  ],
)]
final class LayoutForms {

  use DrupalObjectTrait;

  /**
   * @phpstan-param \Drupal\pinto_layout\PintoLayout\Data\PluginConfiguration<Configuration> $pluginConfiguration
   */
  public function __construct(
    #[Region]
    public readonly mixed $slot1,
    public RegionAttributes $regionAttributes,
    public PluginConfiguration $pluginConfiguration,
    public array $attributes = [],
    public ?string $color = NULL,
    public ?string $size = NULL,
  ) {
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(function (Build $build): Build {
      return $build
        ->set('color', $this->pluginConfiguration['color'] ?? NULL)
        ->set('size', $this->pluginConfiguration['size'] ?? NULL)
        ->set('attributes', $this->regionAttributes->containerAttributes())
        ->set('regionAttributes', $this->regionAttributes->regionsAsArray());
    });
  }

}
