<?php

declare(strict_types=1);

namespace Drupal\pinto_layout\Attribute;

use Drupal\pinto_layout\Discovery\FrozenRegion;

#[\Attribute(flags: \Attribute::TARGET_CLASS)]
class Regions {

  /**
   * @var string[]
   */
  public readonly array $regions;

  /**
   * @var \Drupal\pinto_layout\Discovery\FrozenRegion[]
   */
  private readonly array $regionsData;

  /**
   * @phpstan-param list<string|Region> $regions
   */
  public function __construct(
    array $regions,
  ) {
    $this->regionsData = \array_map(static function (string|Region $region): FrozenRegion {
      $region = \is_string($region) ? new Region($region) : $region;
      return FrozenRegion::create($region);
    }, $regions);
    $this->regions = \array_map(
      static fn (FrozenRegion $region): string => $region->name,
      $this->regionsData,
    );
  }

  /**
   * @phpstan-return iterable<FrozenRegion>
   */
  public function regionDefinitions(): iterable {
    return $this->regionsData;
  }

}
