<?php

declare(strict_types=1);

namespace Drupal\pinto_layout;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderInterface;
use Drupal\pinto_layout\PintoLayout\External\ExternallyDefinedInterface;

/**
 * @internal
 */
final class PintoLayoutServiceProvider implements ServiceProviderInterface {

  public function register(ContainerBuilder $container): void {
    $container->registerForAutoconfiguration(ExternallyDefinedInterface::class)
      ->addTag('pinto_layout.externally_defined');
  }

}
