<?php

declare(strict_types=1);

namespace Drupal\pinto_layout_test\Pinto;

use Drupal\pinto\Object\DrupalObjectTrait;
use Drupal\pinto_layout\Attribute\LayoutDefinition;
use Drupal\pinto_layout\Attribute\Region;
use Drupal\pinto_layout\PintoLayout\Data\LayoutData;
use Drupal\pinto_layout\PintoLayout\Data\RegionAttributes;
use Pinto\Slots\Build;

#[LayoutDefinition(
  factoryMethod: 'customFactory',
)]
final class SimpleFactoryViaClassLayoutDefinitionLayoutData {

  use DrupalObjectTrait;

  public function __construct(
    #[Region]
    public readonly mixed $slot1,
    public RegionAttributes $regionAttributes,
    public array $attributes = [],
  ) {
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(function (Build $build): Build {
      return $build
        ->set('attributes', $this->regionAttributes->containerAttributes())
        ->set('regionAttributes', $this->regionAttributes->regionsAsArray());
    });
  }

  public static function customFactory(LayoutData $layoutData): static {
    return new static(
      slot1: $layoutData->regionsData->getRegion('slot1'),
      regionAttributes: $layoutData->regionAttributes,
    );
  }

}
