<?php

declare(strict_types=1);

namespace Drupal\pinto_layout\PintoLayout\Data;

/**
 * A data transfer object for passing configuration data from forms.
 *
 * @template Configuration of array<mixed>
 * @property Configuration $data
 * @implements \ArrayAccess<key-of<Configuration>, Configuration[key-of<Configuration>]>
 */
final class PluginConfiguration implements \ArrayAccess {

  /**
   * @phpstan-param Configuration $data
   */
  private function __construct(
    private array $data,
  ) {
  }

  /**
   * @phpstan-param array<key-of<Configuration>, mixed> $data
   * @internal
   */
  public static function fromData(array $data): static {
    return new static(
      data: $data,
    );
  }

  /**
   * @phpstan-param key-of<Configuration> $offset
   */
  public function offsetExists(mixed $offset): bool {
    return \array_key_exists($offset, $this->data);
  }

  /**
   * @phpstan-param key-of<Configuration> $offset
   */
  public function offsetGet(mixed $offset): mixed {
    return $this->data[$offset] ?? NULL;
  }

  /**
   * @phpstan-param key-of<Configuration>|null $offset
   * @phpstan-param mixed $value
   */
  public function offsetSet(mixed $offset, mixed $value): void {
    throw new \BadMethodCallException('This array is read-only');
  }

  /**
   * @phpstan-param key-of<Configuration> $offset
   */
  public function offsetUnset(mixed $offset): void {
    throw new \BadMethodCallException('This array is read-only');
  }

}
