<?php

declare(strict_types=1);

namespace Drupal\pinto_layout_support\Plugin\Block;

use Drupal\Core\Block\Attribute\Block;
use Drupal\Core\Block\BlockPluginInterface;
use Drupal\Core\Block\BlockPluginTrait;
use Drupal\Core\Cache\CacheableDependencyTrait;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

#[Block(
  id: self::PLUGIN_ID,
  admin_label: new TranslatableMarkup('PintoLayoutTestBlock'),
  category: new TranslatableMarkup('PintoLayout'),
)]
final class PintoLayoutTestBlock extends PluginBase implements BlockPluginInterface {

  use BlockPluginTrait;
  use CacheableDependencyTrait;

  public const PLUGIN_ID = 'pinto_layout_support_block';
  public const CONFIG_CUSTOM_CONTENT_KEY = 'custom_content';

  /**
   * {@inheritdoc}
   */
  public function build() {
    $build = [];
    $build['custom_content'] = [
      '#plain_text' => $this->getConfiguration()[static::CONFIG_CUSTOM_CONTENT_KEY] ?? '',
    ];
    return $build;
  }

  public function blockForm($form, FormStateInterface $form_state): array {
    throw new \LogicException('not tested');
  }

}
