<?php

declare(strict_types=1);

namespace Drupal\pinto_layout_test\Pinto;

use Drupal\pinto\Object\DrupalObjectTrait;
use Drupal\pinto_layout\Attribute\Region;
use Drupal\pinto_layout\PintoLayout\Data\RegionAttributes;
use Pinto\Slots\Build;

final class Simple {

  use DrupalObjectTrait;

  public function __construct(
    #[Region]
    public readonly mixed $slot1,
    #[Region]
    public readonly mixed $slot2,
    #[Region(label: 'Slot 3 label')]
    public readonly mixed $slot3,
    public RegionAttributes $regionAttributes,
    public array $attributes = [],
  ) {
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(function (Build $build): Build {
      return $build
        ->set('attributes', $this->regionAttributes->containerAttributes())
        ->set('regionAttributes', $this->regionAttributes->regionsAsArray());
    });
  }

}
