<?php

declare(strict_types=1);

namespace Drupal\pinto_layout_test\Pinto;

use Drupal\pinto\Object\DrupalObjectTrait;
use Drupal\pinto_layout\Attribute\LayoutDefinition;
use Drupal\pinto_layout\Attribute\Regions;
use Drupal\pinto_layout\PintoLayout\Data\RegionAttributes;
use Drupal\pinto_layout\PintoLayout\PintoLayoutInterface;
use Pinto\Slots\Build;

#[LayoutDefinition(
  regions: new Regions([
    'sicldSlot1',
    'sicldSlot2',
  ]),
)]
final class SlotsInClassLayoutDefinition implements PintoLayoutInterface {

  use DrupalObjectTrait;

  public function __construct(
    public readonly mixed $sicldSlot1,
    public readonly mixed $sicldSlot2,
    public RegionAttributes $regionAttributes,
    public array $attributes = [],
  ) {
  }

  public function __invoke(): mixed {
    return $this->pintoBuild(function (Build $build): Build {
      return $build
        ->set('attributes', $this->regionAttributes->containerAttributes())
        ->set('regionAttributes', $this->regionAttributes->regionsAsArray());
    });
  }

  public static function createForLayout(\Drupal\pinto_layout\PintoLayout\Data\LayoutData $layoutData): static {
    return new static(
      sicldSlot1: $layoutData->regionsData->getRegion('sicldSlot1'),
      sicldSlot2: $layoutData->regionsData->getRegion('sicldSlot2'),
      regionAttributes: $layoutData->regionAttributes,
    );
  }

}
