<?php

declare(strict_types=1);

namespace Drupal\pinto_theme;

use Drupal\pinto\PintoMappingFactory;
use Drupal\pinto_theme\PintoTheme\Attribute\Theme;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Compiler pass to determine which Pinto lists represent a theme via #[Theme].
 */
final class PintoThemeCompilerPass implements CompilerPassInterface {

  public function process(ContainerBuilder $container): void {
    $mapping = [];

    /** @var array<class-string<\Pinto\List\ObjectListInterface>> $pintoLists */
    $pintoLists = $container->getDefinition(PintoMappingFactory::class)->getArgument('$enumClasses');
    foreach ($pintoLists as $pintoList) {
      foreach ($pintoList::cases() as $case) {
        $rCase = new \ReflectionEnumUnitCase($case::class, $case->name);
        $theme = ($rCase->getAttributes(Theme::class)[0] ?? NULL)?->newInstance() ?? NULL;
        if ($theme !== NULL) {
          $mapping[$theme->themeName] = $case;
        }
      }
    }

    // Serialize until https://www.drupal.org/project/drupal/issues/3522410 is
    // resolved.
    $container->setParameter('pinto_theme.enums', \serialize($mapping));
  }

}
