<?php

declare(strict_types=1);

namespace Drupal\pinto_theme\Render;

use Drupal\Core\Routing\RouteMatchInterface;
use Pinto\List\ObjectListInterface;

/**
 * @internal
 *   For internal use only.
 */
final class PintoRenderContext {

  private function __construct(
    public readonly ObjectListInterface $htmlEnum,
    public array $title,
    public array $content,
    public RouteMatchInterface $routeMatch,
  ) {}

  /**
   * @internal
   */
  public static function createContextFrom(
    ObjectListInterface $htmlEnum,
    array $title,
    array $content,
    RouteMatchInterface $routeMatch,
  ): static {
    return new static($htmlEnum, $title, $content, $routeMatch);
  }

}
