When building a theme with Pinto + Pinto Theme, a highly disciplined approach is recommended. The following is suggested.

- Do not make use of field formatters, even in layout builder.
- Do not use pre/post-processors, including `hook_preprocess_hook`
- Do not use theme suggestions, including `hook_theme_suggestions_alter`.
- A theme should not need a `.theme` file.
- A theme should not have any global libraries or stylesheets.
  Instead, use Pinto's `#[DependencyOn]` with `#[Definition]`-less enums (@todo link)
- A theme should not have regions.
- Layouts may be implemented for use with Layout Builder.

Other notes

- Since blocks are not used to build a page, navigation blocks like menu and breadcrumb are not available for placement in global areas like a header or footer. These will need to be devised manually, using inspiration from the respective block plugin code, or they can be synthetically produced with block plugins.
- Local actions, local tasks, and status messages, may be exposed on the front end manually, if desired.

# Usage

On an existing or new Pinto list create an enum and associated Pinto object code that represents the HTML templates. This object will be used in a way like Drupal does with `html.html.twig` and `page.html.twig`.

## HTML object

Set up object as usual, but add `implements \Drupal\pinto_theme\PintoTheme\Html\PintoThemeHtmlObjectInterface`.

The required `createHtmlObjectFrom` method must return an instance of a Pinto object. It doesn't need to return the same (static) object.

Context is provided, including title, page content, and top and bottom sections (from `hook_page_top` / `hook_page_bottom`). Plus, request related context, like the route match.

Tip: Drupal cores `html.html.twig` and `page.html.twig` duality can be emulated by creating another "Page" pinto object

Tip: Since context can vary by route/request, a different Pinto object can be
returned as a result of different context. Using the separate "Page" object
technique, different `page.html.twig` templates depending on request context can be emulated.

```php
public static function createHtmlObjectFrom(PintoThemeHtmlContext $context): static {
  $page = new Page($context->getTitle(), $context->getContent());
  $top = $context->hasTop() ? $context->getTop() : NULL;
  $bottom = $context->hasBottom() ? $context->getBottom() : NULL;
  return new static($page, $top, $bottom);
}
```

## Pinto List

Ensure the case is set up as usual and point to the Html object.

Add the `#[Theme]` attribute above the Pinto `Html` enum. Modify `$themeName`
argument with the name of the theme.

```php
#[Definition(Html::class)]
#[Theme('dpi_theme')]
case Html;
```
