<?php

declare(strict_types=1);

namespace Drupal\pinto_theme\PintoTheme\Html;

use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Context provided to createHtmlObjectFrom().
 *
 * Context provided to the HTML Pinto object as the PHP object is being produced
 * by createHtmlObjectFrom().
 */
final class PintoThemeHtmlContext {

  private function __construct(
    private array $title,
    private array $content,
    private RouteMatchInterface $routeMatch,
    private bool $hasTop,
    private bool $hasBottom,
    private mixed $top,
    private mixed $bottom,
  ) {}

  /**
   * @internal
   */
  public static function createHtmlContextFrom(
    array $title,
    array $content,
    RouteMatchInterface $routeMatch,
    bool $hasTop,
    bool $hasBottom,
    mixed $top,
    mixed $bottom,
  ): static {
    return new static(
      $title,
      $content,
      $routeMatch,
      $hasTop,
      $hasBottom,
      $top,
      $bottom,
    );
  }

  public function getTitle(): array {
    return $this->title;
  }

  public function getContent(): array {
    return $this->content;
  }

  public function getRouteMatch(): RouteMatchInterface {
    return $this->routeMatch;
  }

  public function hasTop(): bool {
    return $this->hasTop;
  }

  public function hasBottom(): bool {
    return $this->hasBottom;
  }

  public function getTop(): mixed {
    if ($this->hasTop === FALSE) {
      throw new \Exception('No top was set');
    }

    return $this->top;
  }

  public function getBottom(): mixed {
    if ($this->hasBottom === FALSE) {
      throw new \Exception('No bottom was set');
    }

    return $this->bottom;
  }

}
