<?php

declare(strict_types=1);

namespace Drupal\Tests\pinto_theme\Functional;

use Drupal\Core\Url;
use Drupal\Tests\BrowserTestBase;

/**
 * @group pinto_theme
 */
final class PintoThemeTest extends BrowserTestBase {

  protected $defaultTheme = 'empty_theme';

  protected static $modules = [
    'pinto',
    'pinto_theme_test',
    'pinto_theme',
  ];

  public function testPintoTheme(): void {
    $this->config('system.site')
      ->set('page.front', '/front')
      ->set('name', 'My Test Site')
      ->save();
    $this->drupalGet(Url::fromRoute('<front>'));

    $this->assertSession()->statusCodeEquals(200);

    // Basic test to ensure template is used.
    $this->assertSession()->responseContains('<h1>This is the test html template!</h1>');

    // Test content and title are passed through from controller, and site name from config.
    $this->assertSession()->titleEquals('test title | My Test Site');
    $this->assertSession()->responseContains('the front page');
  }

}
