<?php

declare(strict_types=1);

namespace Drupal\pinto_theme\PintoTheme\Html;

/**
 * An object representing the HTML container.
 *
 * Similar to a combined html.html.twig page.html.twig.
 */
interface PintoThemeHtmlObjectInterface {

  /**
   * Create an HTML object from context.
   *
   * An instance of the called object isn't required to be returned (static),
   * but it should be another renderable Pinto object.
   */
  public static function createHtmlObjectFrom(PintoThemeHtmlContext $context): object;

}
