<?php

declare(strict_types=1);

namespace Drupal\pinto_theme\Render;

use Drupal\Core\Routing\RouteMatchInterface;

/**
 * @internal
 *   For internal use only.
 */
final class PintoRenderContext {

  /**
   * @phpstan-param class-string<\Drupal\pinto_theme\PintoTheme\Html\PintoThemeHtmlObjectInterface> $component
   */
  private function __construct(
    public readonly string $component,
    public array $title,
    public array $content,
    public RouteMatchInterface $routeMatch,
  ) {}

  /**
   * @phpstan-param class-string<\Drupal\pinto_theme\PintoTheme\Html\PintoThemeHtmlObjectInterface> $component
   * @internal
   */
  public static function createContextFrom(
    string $component,
    array $title,
    array $content,
    RouteMatchInterface $routeMatch,
  ): static {
    return new static($component, $title, $content, $routeMatch);
  }

}
