/**
 * @file
 * Override the Drupal.bigPipe.commands.insert() method.
 *
 * This works around a TypeError thrown when BigPipe is processing a placeholder
 * in a noscript tag. @see https://www.drupal.org/project/drupal/issues/3550388
 */

((Drupal, htmx) => {
  Drupal.bigPipe.commands.insertOriginal = Drupal.bigPipe.commands.insert;

  Drupal.bigPipe.commands.insert = function ({ data, method, selector }) {
    const target = htmx.find(selector);

    // The target cannot be found if in a noscript element.
    if (target === null) {
      return;
    }

    Drupal.bigPipe.commands.insertOriginal({ data, method, selector });
  };
})(Drupal, htmx);
